/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.clu.antimatter;

import edu.rit.clu.antimatter.AntiprotonFile;
import edu.rit.io.Files;
import edu.rit.mp.DoubleBuf;
import edu.rit.pj.Comm;
import edu.rit.util.Random;
import edu.rit.util.Range;
import edu.rit.vector.Vector2D;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;

public class AntiprotonClu2 {
    static final double QP = 3.0;
    static final double B = 3.0;
    static final double QP_QP = 9.0;
    static final double QP_B = 9.0;
    static Comm world;
    static int size;
    static int rank;
    static int predRank;
    static int succRank;
    static long seed;
    static double R;
    static double dt;
    static int steps;
    static int snaps;
    static int N;
    static File outfile;
    static double one_half_dt_sqr;
    static Range[] slices;
    static Range mySlice;
    static int myLb;
    static int myLen;
    static Vector2D[] a;
    static Vector2D[] v;
    static Vector2D[] p;
    static Vector2D[] p2;
    static Vector2D[] p3;
    static DoubleBuf pbuf;
    static DoubleBuf p2buf;
    static DoubleBuf p3buf;
    static Vector2D temp;
    static Vector2D totalMV;

    private AntiprotonClu2() {
    }

    public static void main(String[] stringArray) throws Exception {
        int n;
        long l = System.currentTimeMillis();
        Comm.init(stringArray);
        world = Comm.world();
        size = world.size();
        rank = world.rank();
        predRank = (rank - 1 + size) % size;
        succRank = (rank + 1) % size;
        if (stringArray.length != 7) {
            AntiprotonClu2.usage();
        }
        seed = Long.parseLong(stringArray[0]);
        R = Double.parseDouble(stringArray[1]);
        dt = Double.parseDouble(stringArray[2]);
        steps = Integer.parseInt(stringArray[3]);
        snaps = Integer.parseInt(stringArray[4]);
        N = Integer.parseInt(stringArray[5]);
        outfile = new File(stringArray[6]);
        one_half_dt_sqr = 0.5 * dt * dt;
        slices = new Range(0, N - 1).subranges(size);
        mySlice = slices[rank];
        myLb = mySlice.lb();
        myLen = mySlice.length();
        Random random = Random.getInstance(seed);
        random.skip(2 * myLb);
        a = new Vector2D[myLen];
        v = new Vector2D[myLen];
        p = new Vector2D[myLen];
        for (n = 0; n < myLen; ++n) {
            AntiprotonClu2.a[n] = new Vector2D();
            AntiprotonClu2.v[n] = new Vector2D();
            AntiprotonClu2.p[n] = new Vector2D(random.nextDouble() * R / 2.0 + R / 4.0, random.nextDouble() * R / 2.0 + R / 4.0);
        }
        p2 = new Vector2D[myLen + 1];
        p3 = new Vector2D[myLen + 1];
        for (n = 0; n <= myLen; ++n) {
            AntiprotonClu2.p2[n] = new Vector2D();
            AntiprotonClu2.p3[n] = new Vector2D();
        }
        pbuf = Vector2D.doubleBuffer(p);
        p2buf = Vector2D.doubleBuffer(p2);
        p3buf = Vector2D.doubleBuffer(p3);
        AntiprotonFile antiprotonFile = new AntiprotonFile(seed, R, dt, steps, snaps + 1, N, myLb, myLen);
        AntiprotonFile.Writer writer = antiprotonFile.prepareToWrite(new BufferedOutputStream(new FileOutputStream(Files.fileForRank(outfile, rank))));
        writer.writeSnapshot(p, 0, totalMV);
        long l2 = System.currentTimeMillis();
        for (int i = 0; i < snaps; ++i) {
            for (int j = 0; j < steps; ++j) {
                AntiprotonClu2.computeAccelerationThisSlice();
                DoubleBuf doubleBuf = pbuf;
                DoubleBuf doubleBuf2 = p3buf;
                for (int k = 1; k < size; ++k) {
                    world.sendReceive(predRank, doubleBuf, succRank, doubleBuf2);
                    Vector2D[] vector2DArray = p2;
                    p2 = p3;
                    p3 = vector2DArray;
                    DoubleBuf doubleBuf3 = p2buf;
                    p2buf = p3buf;
                    p3buf = doubleBuf3;
                    doubleBuf = p2buf;
                    doubleBuf2 = p3buf;
                    AntiprotonClu2.computeAccelerationOtherSlice((rank + k) % size);
                }
                AntiprotonClu2.step();
            }
            AntiprotonClu2.computeTotalMomentum();
            writer.writeSnapshot(p, 0, totalMV);
        }
        writer.close();
        long l3 = System.currentTimeMillis();
        System.out.println(l2 - l + " msec pre " + rank);
        System.out.println(l3 - l2 + " msec calc " + rank);
        System.out.println(l3 - l + " msec total " + rank);
    }

    private static void computeAccelerationThisSlice() {
        for (int i = 0; i < myLen; ++i) {
            double d;
            int n;
            Vector2D vector2D = a[i];
            Vector2D vector2D2 = p[i];
            for (n = 0; n < i; ++n) {
                temp.assign(vector2D2);
                temp.sub(p[n]);
                d = temp.sqrMag();
                temp.mul(9.0 / (d * Math.sqrt(d)));
                vector2D.add(temp);
            }
            for (n = i + 1; n < myLen; ++n) {
                temp.assign(vector2D2);
                temp.sub(p[n]);
                d = temp.sqrMag();
                temp.mul(9.0 / (d * Math.sqrt(d)));
                vector2D.add(temp);
            }
        }
    }

    private static void computeAccelerationOtherSlice(int n) {
        int n2 = slices[n].length();
        for (int i = 0; i < myLen; ++i) {
            Vector2D vector2D = a[i];
            Vector2D vector2D2 = p[i];
            for (int j = 0; j < n2; ++j) {
                temp.assign(vector2D2);
                temp.sub(p2[j]);
                double d = temp.sqrMag();
                temp.mul(9.0 / (d * Math.sqrt(d)));
                vector2D.add(temp);
            }
        }
    }

    private static void step() {
        for (int i = 0; i < myLen; ++i) {
            Vector2D vector2D = a[i];
            Vector2D vector2D2 = v[i];
            Vector2D vector2D3 = p[i];
            temp.assign(vector2D2).mul(9.0).rotate270();
            vector2D.add(temp);
            temp.assign(vector2D2);
            vector2D3.add(temp.mul(dt));
            temp.assign(vector2D);
            vector2D3.add(temp.mul(one_half_dt_sqr));
            temp.assign(vector2D);
            vector2D2.add(temp.mul(dt));
            vector2D.clear();
        }
    }

    private static void computeTotalMomentum() {
        totalMV.clear();
        for (int i = 0; i < myLen; ++i) {
            totalMV.add(v[i]);
        }
    }

    private static void usage() {
        System.err.println("Usage: java -Dpj.np=<K> edu.rit.clu.antimatter.AntiprotonClu2 <seed> <R> <dt> <steps> <snaps> <N> <outfile>");
        System.err.println("<K> = Number of parallel processes");
        System.err.println("<seed> = Random seed for initial antiproton positions");
        System.err.println("<R> = Side of square for initial antiproton positions");
        System.err.println("<dt> = Time step size");
        System.err.println("<steps> = Number of time steps between snapshots");
        System.err.println("<snaps> = Number of snapshots");
        System.err.println("<N> = Number of antiprotons");
        System.err.println("<outfile> = Output file name");
        System.exit(1);
    }

    static {
        temp = new Vector2D();
        totalMV = new Vector2D();
    }
}

