/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.svg.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.function.DoubleFunction;
import org.jfree.svg.util.Args;

public class DoubleConverter
implements DoubleFunction<String> {
    private final DecimalFormat formatter;

    public DoubleConverter(int dp) {
        Args.requireInRange(dp, "dp", 1, 10);
        DecimalFormatSymbols dfs = DecimalFormatSymbols.getInstance(Locale.US);
        this.formatter = new DecimalFormat("0." + "##########".substring(0, dp), dfs);
    }

    @Override
    public String apply(double value) {
        return this.formatter.format(value);
    }
}

