/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pdf.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.jfree.pdf.util.PDFUtils;

public abstract class PDFObject {
    private int number;
    private int generation;

    protected PDFObject(int number) {
        this(number, 0);
    }

    protected PDFObject(int number, int generation) {
        this.number = number;
        this.generation = generation;
    }

    public int getNumber() {
        return this.number;
    }

    public int getGeneration() {
        return this.generation;
    }

    public String getReference() {
        return this.number + " " + this.generation + " R";
    }

    public byte[] toPDFBytes() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(PDFUtils.toBytes(this.objectIntroString()));
        baos.write(this.getObjectBytes());
        baos.write(PDFUtils.toBytes("endobj\n"));
        return baos.toByteArray();
    }

    public abstract byte[] getObjectBytes() throws IOException;

    private String objectIntroString() {
        StringBuilder b = new StringBuilder();
        b.append(this.number).append(" ").append(this.generation).append(" ");
        b.append("obj\n");
        return b.toString();
    }
}

