## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(polynom)
library(HomomorphicEncryption)

## ----params-------------------------------------------------------------------
d  =   4
n  =   2^d
p  =   (n/2)-1
q  = 874

## -----------------------------------------------------------------------------
set.seed(123)

## ----GenPolyMod---------------------------------------------------------------
pm = polynomial( coef=c(1, rep(0, n-1), 1 ) )
print(pm)

## -----------------------------------------------------------------------------
# generate a secret key
s = GenSecretKey(n)
print(s)

## -----------------------------------------------------------------------------
# generate a
a = GenA(n, q)
print(a)

## -----------------------------------------------------------------------------
e = GenError(n)
print(e)

## -----------------------------------------------------------------------------
pk0 = GenPubKey0(a, s, e, pm, q)
print(pk0)

## -----------------------------------------------------------------------------
pk1 = GenPubKey1(a)

## -----------------------------------------------------------------------------
# create a message
m = polynomial( coef=c(6, 4, 2) )

## -----------------------------------------------------------------------------
# polynomials for encryption
e1 = GenError(n)
e2 = GenError(n)
u  = GenU(n)
print(u)

## -----------------------------------------------------------------------------
ct0 = EncryptPoly0(m, pk0, u, e1, p, pm, q)
print(ct0)

## -----------------------------------------------------------------------------
ct1 = EncryptPoly1(   pk1, u, e2,    pm, q)
print(ct1)

## -----------------------------------------------------------------------------
decrypt = (ct1 * s) + ct0
decrypt = decrypt %% pm
decrypt = CoefMod(decrypt, q)

# rescale
decrypt = decrypt * p/q

## -----------------------------------------------------------------------------
# round then mod p
decrypt = CoefMod(round(decrypt), p)
print(decrypt)

