## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
    collapse = TRUE,
    comment = "#>"
)

options(
  rmarkdown.html_vignette.check_title = FALSE
)

## ----setup, message = FALSE, warning = FALSE----------------------------------
library(tidytof)
library(dplyr)

## -----------------------------------------------------------------------------
data(phenograph_data)

set.seed(203L)

phenograph_clusters <-
    phenograph_data |>
    tof_preprocess() |>
    tof_cluster(
        cluster_cols = starts_with("cd"),
        num_neighbors = 50L,
        distance_function = "cosine",
        method = "phenograph"
    ) |>
    tof_metacluster(
        cluster_col = .phenograph_cluster,
        metacluster_cols = starts_with("cd"),
        num_metaclusters = 3L,
        method = "kmeans"
    )

phenograph_clusters |>
    dplyr::select(sample_name, .phenograph_cluster, .kmeans_metacluster) |>
    head()

## -----------------------------------------------------------------------------
phenograph_clusters |>
    dplyr::count(phenograph_cluster, .kmeans_metacluster, sort = TRUE)

## ----eval = FALSE-------------------------------------------------------------
# # use the kmeans algorithm
# phenograph_data |>
#     tof_preprocess() |>
#     tof_cluster(
#         cluster_cols = contains("cd"),
#         method = "kmeans"
#     )
# 
# # use the flowsom algorithm
# phenograph_data |>
#     tof_preprocess() |>
#     tof_cluster(
#         cluster_cols = contains("cd"),
#         method = "flowsom"
#     )

## -----------------------------------------------------------------------------
# will result in a tibble with only 1 column (the cluster labels)
phenograph_data |>
    tof_preprocess() |>
    tof_cluster(
        cluster_cols = contains("cd"),
        method = "kmeans",
        augment = FALSE
    ) |>
    head()

## -----------------------------------------------------------------------------
sessionInfo()

