/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import java.util.List;
import org.dmg.pmml.Array;
import org.dmg.pmml.CompoundPredicate;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.SimpleSetPredicate;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.model.PMMLObjectCache;

public class PredicateManager {
    private PMMLObjectCache<Predicate> cache = new PMMLObjectCache();

    public Predicate createPredicate(Feature feature, List<?> values) {
        if (values.size() == 1) {
            Object value = values.get(0);
            return this.createSimplePredicate(feature, SimplePredicate.Operator.EQUAL, value);
        }
        return this.createSimpleSetPredicate(feature, SimpleSetPredicate.BooleanOperator.IS_IN, values);
    }

    public Predicate createSimplePredicate(Feature feature, SimplePredicate.Operator operator, Object value) {
        SimplePredicate predicate = new SimplePredicate(feature.getName(), operator, value);
        return this.intern((Predicate)predicate);
    }

    public Predicate createSimpleSetPredicate(Feature feature, SimpleSetPredicate.BooleanOperator booleanOperator, List<?> values) {
        Array array = PMMLUtil.createArray(feature.getDataType(), values);
        SimpleSetPredicate predicate = new SimpleSetPredicate(feature.getName(), booleanOperator, array);
        return this.intern((Predicate)predicate);
    }

    public Predicate createCompoundPredicate(CompoundPredicate.BooleanOperator booleanOperator, Predicate ... predicates) {
        CompoundPredicate predicate = new CompoundPredicate(booleanOperator, null).addPredicates(predicates);
        return this.intern((Predicate)predicate);
    }

    public Predicate intern(Predicate predicate) {
        return (Predicate)this.cache.intern((PMMLObject)predicate);
    }
}

