## ----include=FALSE------------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  dev = "svg",
  fig.ext = "svg",
  fig.width = 7.2916667,
  fig.asp = 0.618,
  fig.align = "center",
  out.width = "80%"
)

## -----------------------------------------------------------------------------
library(gsDesign)
library(gsDesignTune)
library(future)

## ----eval=FALSE---------------------------------------------------------------
# plan(multisession, workers = 2)
# 
# job <- gsSurvTune(
#   k = 3,
#   test.type = 4,
#   alpha = 0.025,
#   beta = 0.10,
#   timing = tune_values(list(c(0.33, 0.67, 1), c(0.5, 0.75, 1))),
#   hr = tune_seq(0.60, 0.75, length_out = 5),
#   upper = SpendingFamily$new(
#     SpendingSpec$new(sfLDOF, par = tune_fixed(0)),
#     SpendingSpec$new(sfHSD, par = tune_seq(-4, 4, length_out = 5))
#   ),
#   lower = SpendingSpec$new(sfLDOF, par = tune_fixed(0)),
#   lambdaC = log(2) / 6,
#   eta = 0.01,
#   gamma = c(2.5, 5, 7.5, 10),
#   R = c(2, 2, 2, 6),
#   T = 18,
#   minfup = 6,
#   ratio = 1
# )
# 
# job$run(strategy = "grid", parallel = TRUE, seed = 1, cache_dir = "gstune_cache")

## -----------------------------------------------------------------------------
plan(sequential)

job <- gsDesignTune(
  k = 3,
  test.type = 2,
  alpha = 0.025,
  beta = 0.10,
  timing = tune_values(list(c(0.33, 0.67, 1), c(0.5, 0.75, 1))),
  upper = SpendingFamily$new(
    SpendingSpec$new(sfLDOF, par = tune_fixed(0)),
    SpendingSpec$new(sfHSD, par = tune_seq(-4, 4, length_out = 5))
  )
)

job$run(strategy = "random", n = 5, parallel = FALSE, seed = 123)
head(job$results())

## -----------------------------------------------------------------------------
report_path <- tempfile(fileext = ".html")
job$report(report_path)
report_path

