/*
 * Decompiled with CFR 0.152.
 */
package internal.spreadsheet.base.api.grid;

import ec.util.spreadsheet.Book;
import ec.util.spreadsheet.Sheet;
import internal.spreadsheet.base.api.SpreadSheetConnection;
import internal.spreadsheet.base.api.grid.SheetGridInput;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import jdplus.toolkit.base.api.timeseries.TsCollection;
import jdplus.toolkit.base.tsp.grid.GridInput;
import jdplus.toolkit.base.tsp.grid.GridReader;
import lombok.Generated;
import lombok.NonNull;

public final class SheetGrid
implements SpreadSheetConnection {
    @NonNull
    private final File file;
    @NonNull
    private final Book.Factory factory;
    @NonNull
    private final GridReader reader;

    @Override
    public Optional<TsCollection> getSheetByName(String name) throws IOException {
        Objects.requireNonNull(name);
        try (Book book = this.factory.load(this.file);){
            Optional<TsCollection> optional = this.getSheetByName(book, name);
            return optional;
        }
    }

    @Override
    public List<String> getSheetNames() throws IOException {
        try (Book book = this.factory.load(this.file);){
            List<String> list = this.getSheetNames(book);
            return list;
        }
    }

    @Override
    public List<TsCollection> getSheets() throws IOException {
        try (Book book = this.factory.load(this.file);){
            List<TsCollection> list = this.getSheets(book);
            return list;
        }
    }

    @Override
    public void close() throws IOException {
    }

    private Optional<TsCollection> getSheetByName(Book book, String name) throws IOException {
        for (int i = 0; i < book.getSheetCount2(); ++i) {
            if (!book.getSheetName(i).equals(name)) continue;
            return Optional.of(this.readSheet(book.getSheet(i)));
        }
        return Optional.empty();
    }

    private List<String> getSheetNames(Book book) throws IOException {
        String[] result = new String[book.getSheetCount2()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = book.getSheetName(i);
        }
        return Arrays.asList(result);
    }

    private List<TsCollection> getSheets(Book book) throws IOException {
        TsCollection[] result = new TsCollection[book.getSheetCount2()];
        try {
            book.parallelForEach((sheet, index) -> {
                try {
                    result[index] = this.readSheet((Sheet)sheet);
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            });
        }
        catch (UncheckedIOException ex) {
            throw ex.getCause();
        }
        return Arrays.asList(result);
    }

    private TsCollection readSheet(Sheet sheet) throws IOException {
        return this.reader.read((GridInput)SheetGridInput.of(sheet, this::isSupportedDataType));
    }

    public boolean isSupportedDataType(Class<?> type) {
        return LocalDateTime.class.equals(type) && this.factory.isSupportedDataType(Date.class) || this.factory.isSupportedDataType(type);
    }

    @Generated
    private SheetGrid(@NonNull File file, @NonNull Book.Factory factory, @NonNull GridReader reader) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        if (reader == null) {
            throw new NullPointerException("reader is marked non-null but is null");
        }
        this.file = file;
        this.factory = factory;
        this.reader = reader;
    }

    @Generated
    public static @org.jspecify.annotations.NonNull SheetGrid of(@NonNull File file, @NonNull Book.Factory factory, @NonNull GridReader reader) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        if (reader == null) {
            throw new NullPointerException("reader is marked non-null but is null");
        }
        return new SheetGrid(file, factory, reader);
    }
}

