/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.lightgbm.visitors;

import java.util.List;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.True;
import org.dmg.pmml.tree.Node;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.converter.visitors.AbstractTreeModelTransformer;
import org.jpmml.model.UnsupportedAttributeException;
import org.jpmml.model.UnsupportedElementException;

public class TreeModelCompactor
extends AbstractTreeModelTransformer {
    public void enterNode(Node node) {
        Object id = node.getId();
        Object score = node.getScore();
        Object defaultChild = node.getDefaultChild();
        if (id == null) {
            throw new UnsupportedElementException((PMMLObject)node);
        }
        if (node.hasNodes()) {
            List children = node.getNodes();
            if (defaultChild == null || children.size() != 2) {
                throw new UnsupportedElementException((PMMLObject)node);
            }
            Node firstChild = (Node)children.get(0);
            Node secondChild = (Node)children.get(1);
            if (TreeModelCompactor.equalsNode((Object)defaultChild, (Node)firstChild)) {
                children = TreeModelCompactor.swapChildren((Node)node);
                firstChild = (Node)children.get(0);
                secondChild = (Node)children.get(1);
            } else if (!TreeModelCompactor.equalsNode((Object)defaultChild, (Node)secondChild)) {
                throw new UnsupportedElementException((PMMLObject)node);
            }
            node.setDefaultChild(null);
            secondChild.setPredicate((Predicate)True.INSTANCE);
        } else if (score == null || defaultChild != null) {
            throw new UnsupportedElementException((PMMLObject)node);
        }
        node.setId(null);
    }

    public void exitNode(Node node) {
        Number recordCount = node.getRecordCount();
        Predicate predicate = node.requirePredicate();
        if (recordCount != null) {
            node.setRecordCount(null);
        }
        if (predicate instanceof True) {
            Node parentNode = this.getParentNode();
            if (parentNode == null) {
                return;
            }
            parentNode.setScore(null);
            TreeModelCompactor.initScore((Node)parentNode, (Node)node);
            TreeModelCompactor.replaceChildWithGrandchildren((Node)parentNode, (Node)node);
        }
    }

    public void enterTreeModel(TreeModel treeModel) {
        super.enterTreeModel(treeModel);
        TreeModel.MissingValueStrategy missingValueStrategy = treeModel.getMissingValueStrategy();
        if (missingValueStrategy != TreeModel.MissingValueStrategy.DEFAULT_CHILD) {
            throw new UnsupportedAttributeException((PMMLObject)treeModel, (Enum)missingValueStrategy);
        }
        TreeModel.NoTrueChildStrategy noTrueChildStrategy = treeModel.getNoTrueChildStrategy();
        if (noTrueChildStrategy != TreeModel.NoTrueChildStrategy.RETURN_NULL_PREDICTION) {
            throw new UnsupportedAttributeException((PMMLObject)treeModel, (Enum)noTrueChildStrategy);
        }
        TreeModel.SplitCharacteristic splitCharacteristic = treeModel.getSplitCharacteristic();
        if (splitCharacteristic != TreeModel.SplitCharacteristic.BINARY_SPLIT) {
            throw new UnsupportedAttributeException((PMMLObject)treeModel, (Enum)splitCharacteristic);
        }
        treeModel.setMissingValueStrategy(TreeModel.MissingValueStrategy.NONE).setNoTrueChildStrategy(TreeModel.NoTrueChildStrategy.RETURN_LAST_PREDICTION).setSplitCharacteristic(TreeModel.SplitCharacteristic.MULTI_SPLIT);
    }
}

