/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.sql;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class JarChecksum {
    public static String computeJarChecksum() {
        File currentJavaJarFile = new File(JarChecksum.class.getProtectionDomain().getCodeSource().getLocation().getPath());
        String filepath = currentJavaJarFile.getAbsolutePath();
        StringBuilder checksum = new StringBuilder();
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            FileInputStream fileInputStream = new FileInputStream(filepath);
            byte[] dataBytes = new byte[1024];
            int nread = 0;
            while ((nread = fileInputStream.read(dataBytes)) != -1) {
                messageDigest.update(dataBytes, 0, nread);
            }
            fileInputStream.close();
            byte[] mdBytes = messageDigest.digest();
            for (int i = 0; i < mdBytes.length; ++i) {
                checksum.append(Integer.toString((mdBytes[i] & 0xFF) + 256, 16).substring(1));
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return checksum.toString();
    }
}

